<?php

/* Include setup files */
include 'includes/functions.php';
include 'includes/database.php'; // sets $dbh

// check for POST actions
if(!empty($_POST))
{
    if($_POST['action'] == 'nea_katigoria')
    {
        if( trim($_POST['katigoria']) == "" || trim($_POST['category']) == "" || trim($_POST['categoria']) == "" )
        {
            exit("Τα ονόματα πρέπει να είναι συμπηρωμένα. Πατήστε πίσω και ξαναδοκιμάστε.");
        }
        $sql = "INSERT INTO katigories(katigoria) VALUES(:katigoria, :category, :categoria);";
        $stmt = $dbh->prepare($sql);
        $stmt->execute([
            ":katigoria" => $_POST['katigoria'],
            ":category" => $_POST['category'],
            ":categoria" => $_POST['categoria']
        ]);
        header("Location: /app/el/index.php?action=katigories");
        exit();
    }
    if($_POST['action'] == 'neo_piato')
    {
        if( trim($_POST['onoma']) == "" || trim($_POST['name']) == "" || trim($_POST['nome']) == "" || trim($_POST['timi']) == "")
        {
            exit("Τα ονόματα και η τιμή πρέπει να είναι συμπηρωμένα. Πατήστε πίσω και ξαναδοκιμάστε.");
        }
        $sql = "INSERT INTO piata(id_katigorias, onoma, timi, diathesimo) VALUES(:id_katigorias, :onoma, :name, :nome, :timi, 1);";
        $stmt = $dbh->prepare($sql);
        $stmt->execute(array(
            ":id_katigorias" => $_POST['id_katigorias'],
            ":onoma" => $_POST['onoma'],
            ":name" => $_POST['name'],
            ":nome" => $_POST['nome'],
            ":timi" => string2price($_POST['timi'])
        ));
        header("Location: /app/el/index.php");
        exit();
    }
    if($_POST['action'] == 'deletePiato')
    {
        $sql = "DELETE FROM piata WHERE id = :id;";
        $stmt = $dbh->prepare($sql);
        $stmt->bindParam(':id', $_POST['id'], PDO::PARAM_INT);
        $rows = $stmt->execute();
        echo 'Το '. $_POST['id']. ' διαγράφηκε.';
    }
    if($_POST['action'] == 'updateSeira')
    {
        $sql = "UPDATE katigories SET seira = :seira WHERE id = :id;";
        $stmt = $dbh->prepare($sql);
        $stmt->bindParam(':seira', $_POST['seira'] , PDO::PARAM_INT);
        $stmt->bindParam(':id', $_POST['id'], PDO::PARAM_INT);
        $rows = $stmt->execute();
        echo 'Το '. $_POST['id']. ' αποθηκεύτηκε.';
    }
    if($_POST['action'] == 'updatePrice')
    {
        $sql = "UPDATE piata SET timi = :timi WHERE id = :id;";
        $stmt = $dbh->prepare($sql);
        $stmt->bindParam(':timi', string2price($_POST['timi']) , PDO::PARAM_BOOL);
        $stmt->bindParam(':id', $_POST['id'], PDO::PARAM_INT);
        $rows = $stmt->execute();
        echo 'Το '. $_POST['id']. ' αποθηκεύτηκε.';
    }
    if($_POST['action'] == 'updateAvailability')
    {
        $sql = "UPDATE piata SET diathesimo = :diathesimo WHERE id = :id;";
        $stmt = $dbh->prepare($sql);
        $available = $_POST['diathesimo'] === 'true' ? 1 : 0;
        $stmt->bindParam(':diathesimo', $available , PDO::PARAM_INT);
        $stmt->bindParam(':id', $_POST['id'], PDO::PARAM_INT);
        $rows = $stmt->execute();
        echo 'Το '. $_POST['id']. ' αποθηκεύτηκε.';
    }
    exit();
}


// parse get variables
$allowed_languages = array('gr', 'en', 'it');
if(isset($_GET['language']) && in_array($_GET['language'], $allowed_actions))
{
    $language = $_GET['language'];
} else {
    $language = 'gr'; // default menu language
}

$allowed_actions = array('get_all', 'get_print', 'katigories', 'get_katigories', 'neo_piato', 'nea_katigoria', 'katalogos');
if(isset($_GET['action']) && in_array($_GET['action'], $allowed_actions))
{
    $action = $_GET['action'];
} else {
    $action = 'piata'; // default action
}


if($action == 'get_katigories')
{
    try{
        $katigories = $dbh->query("
                SELECT *
                FROM katigories 
                ORDER BY katigories.seira;
            ")
            ->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode($katigories);
    } catch (Exception $e) {
        echo $e->getMessage();
    }

}


if($action == 'get_print')
{
    $pedio_onomatos = 'onoma';
    $pedio_katigorias = 'katigoria';
    if($language == 'en')
    {
        $pedio_onomatos = 'name';
        $pedio_katigorias = 'category';
    }
    if($language == 'it')
    {
        $pedio_onomatos = 'nome';
        $pedio_katigorias = 'catogeoria';
    }
    try{
        $diathesima_piata = $dbh->query("
                SELECT piata.id, piata.".$pedio_onomatos.", piata.timi, piata.diathesimo, katigories.".$pedio_katigorias." 
                FROM piata JOIN katigories 
                ON piata.id_katigorias = katigories.id 
                WHERE piata.diathesimo = 1
                ORDER BY katigories.id;
            ")
            ->fetchAll(PDO::FETCH_ASSOC);

        $proigoumeni_katigoria = '';
        foreach ($diathesima_piata as $key => $piato)
        {
            $diathesima_piata[$key]['timi'] = str_replace('.', ',', $diathesima_piata[$key]['timi']);
            if($piato[$pedio_katigorias] == $proigoumeni_katigoria)
            {
                $diathesima_piata[$key][$pedio_katigorias] = '';
            } else {
                $proigoumeni_katigoria = $piato[$pedio_katigorias];
            }
        }
        echo json_encode($diathesima_piata);
    } catch (Exception $e) {
        echo $e->getMessage();
    }
}


if($action == 'get_all')
{
    try{
        $diathesima_piata = $dbh->query("
                SELECT piata.id, piata.onoma, piata.timi, piata.diathesimo, katigories.katigoria
                FROM piata JOIN katigories 
                ON piata.id_katigorias = katigories.id 
                ORDER BY katigories.id;
            ")
            ->fetchAll(PDO::FETCH_ASSOC);

        $proigoumeni_katigoria = '';
        foreach ($diathesima_piata as $key => $piato)
        {
            $diathesima_piata[$key]['timi'] = str_replace('.', ',', $diathesima_piata[$key]['timi']);
            $diathesima_piata[$key]['removalUrl'] = '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span><span class="sr-only">Διαγραφή</span>';
            $diathesima_piata[$key]['diathesimo'] =  (bool)$diathesima_piata[$key]['diathesimo'];
            if($piato['katigoria'] == $proigoumeni_katigoria)
            {
                $diathesima_piata[$key]['katigoria'] = '';
            } else {
                $proigoumeni_katigoria = $piato['katigoria'];
            }
        }
        echo json_encode($diathesima_piata);
    } catch (Exception $e) {
        echo $e->getMessage();
    }
}

if($action == 'katigories') // wireframe, data loaded later using AJAX
{
    include 'templates/header.php';
    include 'includes/table_setup_katigories.php';
    $table_id = 'cat_table';
    include 'templates/table.php';
    include 'templates/footer.php';
}


if($action == 'katalogos') // wireframe, data loaded later using AJAX
{
    include 'templates/header.php';
    include 'includes/table_setup_katalogos.php';
    $table_id = 'katalogos';
    include 'templates/table.php';
    include 'templates/footer.php';
}


if($action == 'piata') // wireframe, data loaded later using AJAX
{
    include 'templates/header.php';
    include 'includes/table_setup_piata.php';
    $table_id = 'table';
    include 'templates/table.php';
    include 'templates/footer.php';
}


if($action == 'nea_katigoria')
{
    include 'templates/header.php';
    include 'templates/add_katigoria.php';
    include 'templates/footer.php';
}


if($action == 'neo_piato')
{
    include 'templates/header.php';
    
    try{
        $katigories = $dbh->query("
                SELECT *
                FROM katigories 
                ORDER BY katigories.seira;
            ")
            ->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        echo $e->getMessage();
    }
    include 'templates/add_piato.php';
    include 'templates/footer.php';
}



?>
