$(function () {
    $('#table').bootstrapTable().on('check.bs.table', function (e, row) {
            updateAvailability(row.id, row.diathesimo);
        }).on('uncheck.bs.table', function (e, row) {
            updateAvailability(row.id, row.diathesimo);
        }).on('editable-save.bs.table', function (e, field, row){
            updatePiato(row.id, row.timi, row.onoma, row.name, row.nome);
        }).on('dbl-click-cell.bs.table', function(field, value, row, element){
            deletePiato(value, element.id);
        });
    $('#cat_table').bootstrapTable().on('editable-save.bs.table', function (e, field, row){
            updateKatigoria(row.id, row.seira, row.katigoria, row.category, row.categoria);
        });
});


function deletePiato(value, id)
{
    if(value == "removalUrl")
    {
        if(window.confirm("Θέλετε σίγουρα να διαγράψετε το πιάτο;"))
        {
            $.ajax({
                method: "POST",
                url: "/app/index.php",
                data: { action: "deletePiato", id: id }
            }).done(function(){
                location.reload();
            }).fail(function( jqXHR, textStatus ) {
                alert( "Υπήρξε πρόβλημα στην διαγραφή, παρακαλώ επαναλάβετε την ενέργεια" );
            });
        }
    }
}


function updateKatigoria(id, seira, katigoria, category, categoria)
{
    $.ajax({
        method: "POST",
        url: "/app/index.php",
        data: { 
            action: "updateKatigoria", 
            id: id,
            seira: seira,
            katigoria: katigoria,
            category: category,
            categoria: categoria
        }
    }).done(function(){
        location.reload();
    }).fail(function( jqXHR, textStatus ) {
        alert( "Υπήρξε πρόβλημα στην αποθήκευση, παρακαλώ επαναλάβετε την ενέργεια" );
    });
}


function updatePiato(id, price, onoma, name, nome)
{
    $.ajax({
        method: "POST",
        url: "/app/index.php",
        data: { 
            action: "updatePiato",
            id: id,
            timi: price,
            onoma: onoma,
            name: name,
            nome: nome
        }
    }).fail(function( jqXHR, textStatus ) {
        alert( "Υπήρξε πρόβλημα στην αποθήκευση, παρακαλώ επαναλάβετε την ενέργεια" );
    });
}


function updateAvailability(id, state)
{
    $.ajax({
        method: "POST",
        url: "/app/index.php",
        data: { action: "updateAvailability", id: id, diathesimo: state }
    }).fail(function( jqXHR, textStatus ) {
        alert( "Υπήρξε πρόβλημα στην αποθήκευση, παρακαλώ επαναλάβετε την ενέργεια" );
    });
}
